; //------------------ treeXYZNCTadppp ---------------------------
;lights trees: 1 ambient light & 1 directional light & 3 point lights

; //--------------------- Constants -------------------------------

; genral definitions
#define ZERO c5.x
#define ONE c5.y
#define PI c5.z
#define EPSILON c5.w
#define R_MODEL_VERT r0
#define R_MODEL_NORMAL r1

; fog definitions
#define R_VERT_TO_FOG r5
#define R_VERT_TO_INTERSECT r6
#define R_VERT_DISTANCE r7
#define R_INTERSECT_DISTANCE r8
#define IS_ZERO	r9
#define IS_NEG r10
#define R_FOG r11

; lighting definitions
#define R_TEMP r6
#define R_VERT_TO_LIGHT r7
#define R_ATTENUATION r8
#define R_INTENSITY r9
#define R_DIFFUSE r10
#define R_SPECULAR r11

; //--------------------- Version -------------------------------

; vertex shader version 1.1
xvs.1.1

; //--------------- Apply Vertex Weights ------------------------

; calculate wind facrtor 
; ( vertz - threshold ) / ( maxz - threshold )
mul r2, v0, c70
sub r3, r2, c71

; clamp wind factor
max r3.z, r3.z, c5.x

; make wind factor exponential
mul r3.z, r3.z, r3.z

; multiply wind factor by wind magnitude
mad R_MODEL_VERT, r3.zzzz, c72, v0

; move normal
mov R_MODEL_NORMAL, v1

; //------------------- Xform Vertices -----------------------------

;transform vertices by view/projection matrix
m4x4 oPos, R_MODEL_VERT, c0

; //----------------- Calculate Texture UV -------------------------

;copy texture coordinates to output   
mov oT0.xy, v3

; //--------------------- Calculate Fog ----------------------------

;calculate vertex-to-fog vector
add R_VERT_TO_FOG, c4, -R_MODEL_VERT	
dp3 R_VERT_DISTANCE.w, R_VERT_TO_FOG, R_VERT_TO_FOG
rsq R_VERT_TO_FOG.w, R_VERT_DISTANCE.w

; calculate vertex-to-fog distance
dst R_VERT_DISTANCE, R_VERT_DISTANCE.wwww, R_VERT_TO_FOG.wwww

; calculate range based fog
mad oFog.x, R_VERT_DISTANCE.y, c10.x, c10.y

; //------------------- Calculate Lighting -------------------------

; //--------------------- Ambient Light ----------------------------

; accumulate ambient light
mov R_DIFFUSE, c20

; //-------------------- Point Light One ---------------------------
; point light with linear attenuation

;calculate vertex-to-light vector
add R_VERT_TO_LIGHT, c32, -R_MODEL_VERT	
dp3 R_INTENSITY.x, R_VERT_TO_LIGHT, R_VERT_TO_LIGHT
rsq R_VERT_TO_LIGHT.w, R_INTENSITY.x	

; calculate R_ATTENUATION
dst R_TEMP, R_INTENSITY.xxxx, R_VERT_TO_LIGHT.wwww  ; ( 1, d, d * d, 1/d )
dp3 R_TEMP.w, R_TEMP, c33							; ( a0 + a1 * d + a2 * d2 )
rcp R_ATTENUATION.w, R_TEMP.w						; 1 / (a0 + a1 * d + a2 * d )

; dot light direction with vertex-to-light vector 
dp3 R_INTENSITY.y, c34, R_VERT_TO_LIGHT
min R_INTENSITY.y, R_INTENSITY.y, ZERO
mul R_INTENSITY.y, R_INTENSITY.y, R_INTENSITY.y

; normalize the vertex-to-light vector
mul R_VERT_TO_LIGHT, R_VERT_TO_LIGHT, R_VERT_TO_LIGHT.w	

; dot normal with light vector 
dp3 R_INTENSITY.z, R_MODEL_NORMAL, R_VERT_TO_LIGHT
max R_INTENSITY.z, R_INTENSITY.z, ZERO

; construct numerator 
mul R_TEMP.x, c35.x, R_INTENSITY.x
add R_TEMP.x, R_INTENSITY.y, -R_TEMP.x
; construct denominator
mul R_TEMP.w, c35.y, R_INTENSITY.y
rcp R_TEMP.w, R_TEMP.w
;// multiply
mul R_TEMP.z, R_TEMP.x, R_TEMP.w
;// max
max R_TEMP.z, R_TEMP.z, c35.z

; accumulate intensity
mul R_INTENSITY.z, R_INTENSITY.z, R_ATTENUATION.w
mul R_INTENSITY.z, R_INTENSITY.z, R_TEMP.z

; accumulate diffuse light
mad R_DIFFUSE, R_INTENSITY.z, c31, R_DIFFUSE
; accumulate ambient light
mad R_DIFFUSE, R_INTENSITY.z, c30, R_DIFFUSE

; //-------------------- Point Light Two ---------------------------
; point light with linear attenuation

;calculate vertex-to-light vector
add R_VERT_TO_LIGHT, c42, -R_MODEL_VERT	
dp3 R_INTENSITY.x, R_VERT_TO_LIGHT, R_VERT_TO_LIGHT
rsq R_VERT_TO_LIGHT.w, R_INTENSITY.x	

; calculate R_ATTENUATION
dst R_TEMP, R_INTENSITY.xxxx, R_VERT_TO_LIGHT.wwww  ; ( 1, d, d * d, 1/d )
dp3 R_TEMP.w, R_TEMP, c43							; ( a0 + a1 * d + a2 * d2 )
rcp R_ATTENUATION.w, R_TEMP.w						; 1 / (a0 + a1 * d + a2 * d )

; dot light direction with vertex-to-light vector 
dp3 R_INTENSITY.y, c44, R_VERT_TO_LIGHT
min R_INTENSITY.y, R_INTENSITY.y, ZERO
mul R_INTENSITY.y, R_INTENSITY.y, R_INTENSITY.y

; normalize the vertex-to-light vector
mul R_VERT_TO_LIGHT, R_VERT_TO_LIGHT, R_VERT_TO_LIGHT.w	

; dot normal with light vector 
dp3 R_INTENSITY.z, R_MODEL_NORMAL, R_VERT_TO_LIGHT
max R_INTENSITY.z, R_INTENSITY.z, ZERO

; construct numerator 
mul R_TEMP.x, c45.x, R_INTENSITY.x
add R_TEMP.x, R_INTENSITY.y, -R_TEMP.x
; construct denominator
mul R_TEMP.w, c45.y, R_INTENSITY.y
rcp R_TEMP.w, R_TEMP.w
;// multiply
mul R_TEMP.z, R_TEMP.x, R_TEMP.w
;// max
max R_TEMP.z, R_TEMP.z, c45.z

; accumulate intensity
mul R_INTENSITY.z, R_INTENSITY.z, R_ATTENUATION.w
mul R_INTENSITY.z, R_INTENSITY.z, R_TEMP.z

; accumulate diffuse light
mad R_DIFFUSE, R_INTENSITY.z, c41, R_DIFFUSE
; accumulate ambient light
mad R_DIFFUSE, R_INTENSITY.z, c40, R_DIFFUSE

; //------------------- Point Light Three --------------------------
; point light with linear attenuation

;calculate vertex-to-light vector
add R_VERT_TO_LIGHT, c52, -R_MODEL_VERT	
dp3 R_INTENSITY.x, R_VERT_TO_LIGHT, R_VERT_TO_LIGHT
rsq R_VERT_TO_LIGHT.w, R_INTENSITY.x	

; calculate R_ATTENUATION
dst R_TEMP, R_INTENSITY.xxxx, R_VERT_TO_LIGHT.wwww  ; ( 1, d, d * d, 1/d )
dp3 R_TEMP.w, R_TEMP, c53							; ( a0 + a1 * d + a2 * d2 )
rcp R_ATTENUATION.w, R_TEMP.w						; 1 / (a0 + a1 * d + a2 * d )

; dot light direction with vertex-to-light vector 
dp3 R_INTENSITY.y, c54, R_VERT_TO_LIGHT
min R_INTENSITY.y, R_INTENSITY.y, ZERO
mul R_INTENSITY.y, R_INTENSITY.y, R_INTENSITY.y

; normalize the vertex-to-light vector
mul R_VERT_TO_LIGHT, R_VERT_TO_LIGHT, R_VERT_TO_LIGHT.w	

; dot normal with light vector 
dp3 R_INTENSITY.z, R_MODEL_NORMAL, R_VERT_TO_LIGHT
max R_INTENSITY.z, R_INTENSITY.z, ZERO

; construct numerator 
mul R_TEMP.x, c55.x, R_INTENSITY.x
add R_TEMP.x, R_INTENSITY.y, -R_TEMP.x
; construct denominator
mul R_TEMP.w, c55.y, R_INTENSITY.y
rcp R_TEMP.w, R_TEMP.w
;// multiply
mul R_TEMP.z, R_TEMP.x, R_TEMP.w
;// max
max R_TEMP.z, R_TEMP.z, c55.z

; accumulate intensity
mul R_INTENSITY.z, R_INTENSITY.z, R_ATTENUATION.w
mul R_INTENSITY.z, R_INTENSITY.z, R_TEMP.z

; accumulate diffuse light
mad R_DIFFUSE, R_INTENSITY.z, c51, R_DIFFUSE
; accumulate ambient light
mad R_DIFFUSE, R_INTENSITY.z, c50, R_DIFFUSE

; //-------------------- Point Light Four --------------------------
; point light with linear attenuation

;calculate vertex-to-light vector
add R_VERT_TO_LIGHT, c62, -R_MODEL_VERT	
dp3 R_INTENSITY.x, R_VERT_TO_LIGHT, R_VERT_TO_LIGHT
rsq R_VERT_TO_LIGHT.w, R_INTENSITY.x	

; calculate R_ATTENUATION
dst R_TEMP, R_INTENSITY.xxxx, R_VERT_TO_LIGHT.wwww  ; ( 1, d, d * d, 1/d )
dp3 R_TEMP.w, R_TEMP, c63							; ( a0 + a1 * d + a2 * d2 )
rcp R_ATTENUATION.w, R_TEMP.w						; 1 / (a0 + a1 * d + a2 * d )

; dot light direction with vertex-to-light vector 
dp3 R_INTENSITY.y, c64, R_VERT_TO_LIGHT
min R_INTENSITY.y, R_INTENSITY.y, ZERO
mul R_INTENSITY.y, R_INTENSITY.y, R_INTENSITY.y

; normalize the vertex-to-light vector
mul R_VERT_TO_LIGHT, R_VERT_TO_LIGHT, R_VERT_TO_LIGHT.w	

; dot normal with light vector 
dp3 R_INTENSITY.z, R_MODEL_NORMAL, R_VERT_TO_LIGHT
max R_INTENSITY.z, R_INTENSITY.z, ZERO

; construct numerator 
mul R_TEMP.x, c65.x, R_INTENSITY.x
add R_TEMP.x, R_INTENSITY.y, -R_TEMP.x
; construct denominator
mul R_TEMP.w, c65.y, R_INTENSITY.y
rcp R_TEMP.w, R_TEMP.w
;// multiply
mul R_TEMP.z, R_TEMP.x, R_TEMP.w
;// max
max R_TEMP.z, R_TEMP.z, c65.z

; accumulate intensity
mul R_INTENSITY.z, R_INTENSITY.z, R_ATTENUATION.w
mul R_INTENSITY.z, R_INTENSITY.z, R_TEMP.z

; accumulate diffuse light
mad R_DIFFUSE, R_INTENSITY.z, c61, R_DIFFUSE
; accumulate ambient light
mad R_DIFFUSE, R_INTENSITY.z, c60, R_DIFFUSE

; //----------------------- Clamp Color --------------------------

max R_DIFFUSE, R_DIFFUSE, c5.x
min R_DIFFUSE, R_DIFFUSE, c5.y
mov oD0, R_DIFFUSE

